'==========================================================================
' NAME: AdAccounts
'
' COMMENT:  Script to create accoutns in AD
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'==========================================================================


Function CreateUser(strName,strPassword)
'===============================================
'	Name: CreateUser
'	IN: strname - name of the user to create
'	OUT: Message
'	Comment: Create a user inthe Users OU
'==============================================

	Dim oRootDSE
	Dim oOU
	Dim oUser
	Dim oGroup
	'Get reference to the rootDSE
	Set oRootDSE =GetObject("LDAP://RootDSE")
	'Get the Users OU
	Set oOU = GetObject("LDAP://CN=Users,"  & oRootDSE.get("defaultNamingContext"))
	'Create the User
	Set oUser = oOU.Create("User","cn=" & strName)
	oUser.Put "sAMAccountName", strName
	oUser.SetInfo
	
	oUser.SetPassword strPassword
	oUser.AccountDisabled = False
	oUser.SetInfo
	
	'Add the user the Windows-based Hosting Service Accounts group
	Set oGroup = GetObject("LDAP://CN=Windows-based Hosting Service Accounts,CN=Users," & oRootDSE.get("defaultNamingContext"))
	oGroup.add oUser.AdsPath
	
	Set oGroup=Nothing
	Set oUser =Nothing
	Set oOU=Nothing
	Set oRootDSE = Nothing
	CreateUser = "FTP User Created."


End Function
